<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;


use App\Services\RemoteApiService;

class DashboardController extends Controller
{
    public function index(){
/* 
        $response = Http::withBasicAuth('geeth', 'abc123')
        ->withHeaders([
            'Accept' => 'application/json',
            'Content-Type' => 'application/json',
        ])
        ->send('POST', 'http://94.156.189.111:8080/XCore/API/gps/current', [
            'body' => json_encode([
                'empid' => '2103',
                'rollid' => '4'
            ]),
        ]);
        if ($response->successful()) {
            $vehicles = $response->json(); // This will be an array of arrays
            var_dump($vehicles);
        } else {
            $vehicles = []; // Or handle error/log
        } */
        

        $service = app(RemoteApiService::class);
        $vehicles = collect($service->fetchCurrentLocations(session('login')));

        $data = [
            'vehicles' => $vehicles,
            'totalVehicles' => $vehicles->count(),
            'onlineVehicles' => $vehicles->where('online', '1')->count(),
            'offlineVehicles' => $vehicles->where('acc', '!=', '3')->count(),
            'avgSpeed' => round($vehicles->where('acc', 3)->avg('speed'), 1),
            'movingVehicles' => $vehicles->where('moving', 1)->count(),
            'lastSync' => now()->format('H:i'),
        ];


        return view('pages.dashboard', $data);
    }
}
