<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Blade::if('role', function ($roles) {
            $user = auth()->user();
            if (!$user) return false;
    
            // If passed a single number
            if (is_numeric($roles)) {
                return $user->rolls == $roles;
            }
    
            // If passed an array
            if (is_array($roles)) {
                return in_array($user->rolls, $roles);
            }
    
            return false;
        });
    }
}
