<?php

use Illuminate\Support\Facades\Route;
use App\Http\Middleware\CheckLogin;

use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\AdminController;


Route::get('/', function () {
    if (session()->has('user_id')) {
        return redirect()->route('dashboard');
    } else {
        return redirect()->route('login');
    }
});

Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->name('login.submit');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');


// Route::middleware([CheckLogin::class])->get('/dashboard', function () {
//     return view('pages.home');
// })->name('dashboard');


Route::middleware([CheckLogin::class])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/admin/user', [AdminController::class, 'create'])->name('admin.user');
    Route::post('/admin/user', [AdminController::class, 'create'])->name('admin.user.store');
});