

<?php $__env->startSection('title'); ?>
    Admin | FNH
<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
<script src="https://use.fontawesome.com/releases/v6.2.0/js/all.js"></script>

<link rel="stylesheet" href="<?php echo e(asset('assets/admin')); ?>/css/gmap.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div id="paper-middle">
<div id="map" style="height: 550px;"></div>
            </div>

            <!--  DEVICE MANAGER -->
            <div class="content-wrap">
                <div class="row">
                    <div class="col-lg-3">
                        <div class="profit" id="profitClose">
                            <div class="headline ">
                                <h3>
                                    <span>
                                    <i class="fa fa-satellite-dish"></i>&#160;&#160; Synced Time</span>
                                </h3>
                                <div class="titleClose">
                                    <a href="#profitClose" class="gone">
                                        <span class="entypo-cancel"></span>
                                    </a>
                                </div>
                            </div>

                            <div class="value">
                                <span class="pull-left"><i class="entypo-clock clock-position"></i>
                                </span>
                                <div id="getting-started">
                                    <?php echo e($lastSync); ?>

                                </div>


                            </div>

                            <div class="progress-tinny">
                                <div style="width: 50%" class="bar"></div>
                            </div>
                            <div class="profit-line">
                                <i class="fa fa-caret-up fa-lg"></i>&#160;&#160; 50% &#160;From Last Hour</div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="revenue" id="revenueClose">
                            <div class="headline ">

                                <h3>
                                    <span>
                                        <i class="maki-aboveground-rail"></i>&#160;&#160;Avg Speed <?php echo e($avgSpeed); ?></span>
                                </h3>

                                <div class="titleClose">
                                    <a href="#revenueClose" class="gone">
                                        <span class="entypo-cancel"></span>
                                    </a>
                                </div>
                            </div>
                            <div class="value">
                                <span class="pull-left"><i class="entypo-gauge gauge-position"></i>
                                </span>
                                <canvas id="canvas4" width="70" height="70"></canvas>
                                <i class="pull-right">/Km</i>

                            </div>








                            <div class="progress-tinny">
                                <div style="width: 25%" class="bar"></div>
                            </div>
                            <div class="profit-line">
                                <i class="fa fa-caret-down fa-lg"></i>&#160;&#160;Live Fleet Avg</div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="order" id="orderClose">
                            <div class="headline ">
                                <h3>
                                    <span>
                                    <i class="fa fa-route"></i>&#160;&#160;Moving Now</span>
                                </h3>
                                <div class="titleClose">
                                    <a href="#orderClose" class="gone">
                                        <span class="entypo-cancel"></span>
                                    </a>
                                </div>
                            </div>
                            <div class="value">
                                <span><i class="fa fa-car text-info"></i>
                                </span><?php echo e($movingVehicles); ?><b> Moving</b>

                            </div>

                            <div class="progress-tinny">
                                <div style="width: 10%" class="bar"></div>
                            </div>
                            <div class="profit-line">
                                <i class="fa fa-caret-down fa-lg"></i>&#160;&#160;<?php echo e(round(($movingVehicles / $totalVehicles) * 100)); ?>% Real-Time Movement</div>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class=" member" id="memberClose">
                            <div class="headline ">
                                <h3>
                                    <span>
                                    <i class="fa fa-truck-moving"></i> 
                                        &#160;&#160;Total Vehicles
                                    </span>
                                </h3>
                                <div class="titleClose">
                                    <a href="#memberClose" class="gone">
                                        <span class="entypo-cancel"></span>
                                    </a>
                                </div>
                            </div>
                            <div class="value">
                                <span><i class="maki-warehouse"></i>
                                </span> <?php echo e($totalVehicles); ?><b>Online</b>

                            </div>
                            <div class="progress-tinny">
                                <div style="width: 50%" class="bar"></div>
                            </div>
                            <div class="profit-line">
                                <span class="entypo-down-circled"></span>&#160;<?php echo e($offlineVehicles); ?> stoped</div>
                        </div>
                    </div>
                </div>
            </div>
            <!--  / DEVICE MANAGER -->


            <div class="content-wrap">
                <div class="row">
                    <div class="col-lg-8">
                        <div id="siteClose" class="nest">
                            <div class="title-alt">
                                <h6>
                                    <span class="fontawesome-truck"></span>&nbsp;Destination</h6>
                                <div class="titleClose">
                                    <a class="gone" href="#siteClose">
                                        <span class="entypo-cancel"></span>
                                    </a>
                                </div>
                                <div class="titleToggle">
                                    <a class="nav-toggle-alt" href="#site">
                                        <span class="entypo-up-open"></span>
                                    </a>
                                </div>
                            </div>
                            <div id="site" class="body-nest" style="min-height:296px;">
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($vehicle['speed'] > 0): ?>
<tr>
    <td class="armada-devider">
        <div class="armada">
            <span style="background:#65C3DF">
                <span class="maki-bus"></span>&nbsp;&nbsp;<?php echo e($vehicle['number']); ?></span>
            <p>
                <span class="entypo-gauge"></span>&nbsp;<?php echo e($vehicle['speed']); ?> Km/<i>Hours</i>
            </p>
        </div>
    </td>
    <td class="driver-devider">
        <img class="armada-pic img-circle" alt="" src="https://api.randomuser.me/portraits/thumb/men/<?php echo e(rand(10, 90)); ?>.jpg">
        <h3><?php echo e($vehicle['contact'] ?? 'Unknown'); ?></h3>
        <br>
        <p>Driver</p>
    </td>
    <td class="progress-devider">
        <section>
            <article>
                <div class="number-pb">
                    <div class="number-pb-shown"></div>
                    <div class="number-pb-num"><?php echo e(rand(30, 90)); ?>%</div> <!-- Simulate progress -->
                </div>
            </article>
        </section>
        <span class="label pull-left">Origin</span>
        <span class="label pull-right">Destination</span>
    </td>
</tr>
<?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4">
                        <div id="RealTimeClose" class="nest">
                            <div class="title-alt">
                                <h6>
                                    <span class="fontawesome-resize-horizontal"></span>&nbsp;Direction</h6>
                                <div class="titleClose">
                                    <a class="gone" href="#RealTimeClose">
                                        <span class="entypo-cancel"></span>
                                    </a>
                                </div>
                                <div class="titleToggle">
                                    <a class="nav-toggle-alt" href="#RealTime">
                                        <span class="entypo-up-open"></span>
                                    </a>
                                </div>
                            </div>
                            <div id="RealTime" style="min-height:296px;padding-top:20px;" class="body-nest">
                                <ul class="direction">
                                    <li>
                                        <span class="direction-icon maki-fuel" style="background:#FF6B6B"></span>
                                        <h3>
                                            <span>Gas Station</span>
                                        </h3>
                                        <p>5 Km Foward&nbsp;&nbsp;<i class="fa fa-arrow-circle-up"></i>
                                        </p>
                                        <p><i>Estimated time </i>:&nbsp;<i class="fa fa-clock-o"></i>&nbsp;&nbsp;20 Min</p>
                                    </li>
                                    <li class="divider"></li>
                                    <li>
                                        <span class="direction-icon maki-fast-food" style="background:#65C3DF"></span>
                                        <h3>
                                            <span>Restourant</span>
                                        </h3>
                                        <p>1 Km Turn Left&nbsp;&nbsp;<i class="fa fa-reply"></i>
                                        </p>
                                        <p><i>Estimated time </i>:&nbsp;<i class="fa fa-clock-o"></i>&nbsp;&nbsp;20 Min</p>
                                    </li>
                                    <li class="divider"></li>
                                    <li>
                                        <span class="direction-icon maki-giraffe" style="background:#45B6B0"></span>
                                        <h3>
                                            <span>Zoo</span>
                                        </h3>
                                        <p>3 Km Turn Right &nbsp;&nbsp;<i class="fa fa-share"></i>
                                        </p>
                                        <p><i>Estimated time </i>:&nbsp;<i class="fa fa-clock-o"></i>&nbsp;&nbsp;20 Min</p>
                                    </li>
                                    <li class="divider"></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="content-wrap">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="chart-wrap">
                            <div class="chart-dash">
                                <!-- <div id="sparkline"></div> -->
                                <div id="placeholder" style="width:100%;height:200px;"></div>
                            </div>
                            <div class="row">
                                <div class="col-lg-8">
                                    <div class="speed">
                                        <h2>Speed Avarage</h2>
                                        <h1>74
                                            <span>Km / hours</span>
                                        </h1>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="traffic">
                                        <h2>Traffic per day</h2>
                                        <h1>2.5874</h1>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="traffic-rates">
                                        <h4>Traffic Rates</h4>
                                        <h1>76 %
                                            <span>-1,2 %</span>
                                        </h1>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="traffic-rates">
                                        <h4>Traffic Rates</h4>
                                        <h1>25 %
                                            <span>-1,8 %</span>
                                        </h1>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="traffic-rates">
                                        <h4>Traffic Rates</h4>
                                        <h1>83 %
                                            <span>-1,9 %</span>
                                        </h1>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="weather-wrap">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="temperature"><b>Monday</b>, 07:30 AM
                                        <span>F</span>
                                        <span><b>C</b>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4">
                                    <div class="weather-icon">
                                        <i class="wi-day-lightning"></i>
                                    </div>
                                </div>
                                <div class="col-lg-8">
                                    <div class="weather-text">
                                        <h2>Berlin
                                            <br><i>Day Lightning</i>
                                        </h2>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="weather-text">
                                        <h3><i class="wi-thermometer"></i>18<i class="wi-celcius"></i>
                                        </h3>
                                    </div>
                                </div>
                            </div>
                            <div class="weather-dash">
                                <div class="row">
                                    <div class="col-lg-2">
                                        <div class="daily-weather">
                                            <h2>Mon</h2>
                                            <h3>85
                                                <span><i class="wi-fahrenheit"></i>
                                                </span>
                                            </h3>
                                            <h4>
                                                <span><i class="wi-day-lightning"></i>
                                                </span>
                                            </h4>
                                            <h5>15
                                                <i>km/h</i>
                                            </h5>
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="daily-weather">
                                            <h2>Tue</h2>
                                            <h3>81
                                                <span><i class="wi-fahrenheit"></i>
                                                </span>
                                            </h3>
                                            <h4><i class="wi-day-cloudy"></i>
                                            </h4>
                                            <h5>12
                                                <i>km/h</i>
                                            </h5>
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="daily-weather">
                                            <h2>Wed</h2>
                                            <h3>83
                                                <span><i class="wi-fahrenheit"></i>
                                                </span>
                                            </h3>
                                            <h4><i class="wi-rain-mix"></i>
                                            </h4>
                                            <h5>14
                                                <i>km/h</i>
                                            </h5>
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="daily-weather">
                                            <h2>Thu</h2>
                                            <h3>80
                                                <span><i class="wi-fahrenheit"></i>
                                                </span>
                                            </h3>
                                            <h4><i class="wi-day-sunny"></i>
                                            </h4>
                                            <h5>15
                                                <i>km/h</i>
                                            </h5>
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="daily-weather">
                                            <h2>Fri</h2>
                                            <h3>79
                                                <span><i class="wi-fahrenheit"></i>
                                                </span>
                                            </h3>
                                            <h4><i class="wi-day-storm-showers"></i>
                                            </h4>
                                            <h5>11
                                                <i>km/h</i>
                                            </h5>
                                        </div>
                                    </div>
                                    <div class="col-lg-2">
                                        <div class="daily-weather">
                                            <h2>Sat</h2>
                                            <h3>82
                                                <span><i class="wi-fahrenheit"></i>
                                                </span>
                                            </h3>
                                            <h4><i class="wi-cloudy"></i>
                                            </h4>
                                            <h5>10
                                                <i>km/h</i>
                                            </h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /END OF CONTENT -->



                <!-- FOOTER -->
                <div class="footer-space"></div>
                <div id="footer">
                    <div class="devider-footer-left"></div>
                    <div class="time">
                        <p id="spanDate"></p>
                        <p id="clock"></p>
                    </div>
                    <div class="copyright">Make with Love
                        <span class="entypo-heart"></span>2014 <a href="http://themeforest.net/item/apricot-navigation-admin-dashboard-template/7664475?WT.ac=category_item&WT.z_author=themesmile">(Themesmile) Purchase This Item</a> All Rights Reserved</div>
                    <div class="devider-footer"></div>


                </div>
                <!-- / END OF FOOTER -->


            </div>

               

<?php $__env->stopSection(); ?>


<?php $__env->startSection('pre-scripts'); ?>
    <!-- Google Maps API -->
    <!-- <script src="https://maps.googleapis.com/maps/api/js?key=YOUR_GOOGLE_MAPS_API_KEY"></script> -->




<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
  (g=>{var h,a,k,p="The Google Maps JavaScript API",c="google",l="importLibrary",q="__ib__",m=document,b=window;b=b[c]||(b[c]={});var d=b.maps||(b.maps={}),r=new Set,e=new URLSearchParams,u=()=>h||(h=new Promise(async(f,n)=>{await (a=m.createElement("script"));e.set("libraries",[...r]+"");for(k in g)e.set(k.replace(/[A-Z]/g,t=>"_"+t[0].toLowerCase()),g[k]);e.set("callback",c+".maps."+q);a.src=`https://maps.${c}apis.com/maps/api/js?`+e;d[q]=f;a.onerror=()=>h=n(Error(p+" could not load."));a.nonce=m.querySelector("script[nonce]")?.nonce||"";m.head.append(a)}));d[l]?console.warn(p+" only loads once. Ignoring:",g):d[l]=(f,...n)=>r.add(f)&&u().then(()=>d[l](f,...n))})({
    key: "AIzaSyBy5peQG2Vn2MmPWxBUf4v608wkAmF73kk",
    v: "weekly",
    // Use the 'v' parameter to indicate the version to use (weekly, beta, alpha, etc.).
    // Add other bootstrap parameters as needed, using camel case.
  });
</script>
<script>
let map;
let highlightedMarker = null;

const markers = {};
    async function initMap() {
  // Request needed libraries.
  const { Map } = await google.maps.importLibrary("maps");
  const { AdvancedMarkerElement } = await google.maps.importLibrary("marker");
  const center = { lat: 7.8731, lng: 80.7718 };
  map = new Map(document.getElementById("map"), {
    zoom: 8,
    center,
    mapId: "4504f8b37365c3d0",
  });
  const bounds = new google.maps.LatLngBounds();

  for (const vehicle of properties) {
    const AdvancedMarkerElement = new google.maps.marker.AdvancedMarkerElement({
      map,
      content: buildContent(vehicle),
      position: vehicle.position,
      title: vehicle.description,
    });

    AdvancedMarkerElement.addListener("click", () => {
      toggleHighlight(AdvancedMarkerElement, vehicle);
    });
    markers[vehicle.number] = AdvancedMarkerElement;
    bounds.extend(vehicle.position);
  }
  
  map.fitBounds(bounds);

}

function toggleHighlight(markerView, vehicle) {
    if (highlightedMarker === markerView) {
        markerView.content.classList.remove("highlight");
        markerView.zIndex = null;
        highlightedMarker = null;
    } else {
        if (highlightedMarker) {
            highlightedMarker.content.classList.remove("highlight");
            highlightedMarker.zIndex = null;
        }
        markerView.content.classList.add("highlight");
        markerView.zIndex = 1;
        highlightedMarker = markerView;
    }
}


function buildContent(vehicle) {
  const content = document.createElement("div");

  content.classList.add("vehicle");
  content.innerHTML = `
    <div class="icon">
        <i aria-hidden="true" class="fa fa-icon fa-${vehicle.type} ${vehicle.status}" title="${vehicle.number}"></i>
        <span class="fa-sr-only">${vehicle.type}</span>
    </div>
    <div class="details">
        <div class="price">${vehicle.number}</div>
        <div class="address">${vehicle.address}</div>
        <div class="features">
        <div>
            <i aria-hidden="true" class="fa fa-truck-fast fa-lg speed" title="speed"></i>
            <span class="fa-sr-only">speed</span>
            <span>${vehicle.speed} km/h</span>
        </div>
        <div>
            <i aria-hidden="true" class="entypo-key bath" title="acc"></i>
            <span class="fa-sr-only">status</span>
            <span>${vehicle.status}</span>
        </div>
        <div>
            <i aria-hidden="true" class="fa fa-compass fa-lg course" title="course"></i>
            <span class="fa-sr-only">course</span>
            <span>${vehicle.course}</span>
        </div>
        </div>
    </div>
    `;
  return content;
}

const properties = [
        <?php $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $vehicleTime = \Carbon\Carbon::parse($v['time']);
        $now = \Carbon\Carbon::now();
        $timeDiffInDays = $vehicleTime->diffInDays($now);
        
        if ($v['speed'] > 0 && $v['acc'] == 3 && $v['moving'] == 1) {
            $status = 'running';
        } elseif ($v['speed'] == 0 && $v['acc'] == 3 && $v['moving'] == 1) {
            $status = 'idle';
        } elseif ($v['speed'] == 0 && $v['acc'] == 2 && $v['moving'] == 2) {
            $status = 'stopped';
        } elseif ($timeDiffInDays >= 1) {
            $status = 'offline';
        } else {
            $status = 'error';
        }
    ?>
  {
    address: "<?php echo e($v['time']); ?>",
    description: "<?php echo e($v['number']); ?>",
    number: "<?php echo e($v['number']); ?>",
    type: "car",
    course: <?php echo e($v['course']); ?>,
    bath: <?php echo e($v['acc']); ?>,
    speed: <?php echo e($v['speed']); ?>,
    position: { lat: <?php echo e($v['lat']); ?>, lng: <?php echo e($v['lng']); ?> },
    status: "<?php echo e($status); ?>",
  },
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
];


initMap();

function focusOnVehicle(number) {
  const marker = markers[number];
  if (marker) {
    map.panTo(marker.position);
    map.setZoom(14); // Optional: zoom in
    toggleHighlight(marker, properties.find(v => v.number === number));
  }
}

</script>


<script async defer
    src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(env('AIzaSyBy5peQG2Vn2MmPWxBUf4v608wkAmF73kk')); ?>&callback=initMap">
</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.template', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/testapp/resources/views/pages/dashboard.blade.php ENDPATH**/ ?>